package commands

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/pocs/ycloud/certorium/crt"
)

var ykCert []byte

var rootCmd = &cobra.Command{
	Use:          "certorium",
	SilenceUsage: true,
	PersistentPreRunE: func(_ *cobra.Command, _ []string) error {
		crtUser := os.Getenv("CRT_USER")
		if crtUser == "" {
			crtUser = "axlodin"
		}

		var err error
		ykCert, err = crt.GenYkCert(crtUser)
		if err != nil {
			return fmt.Errorf("failed to generate ykcert: %w", err)
		}
		return nil
	},
}

func Execute() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}

func init() {
	rootCmd.AddCommand(
		listCmd,
		getCmd,
	)
}
