package crt

import (
	"crypto/rand"
	"crypto/rsa"
	"crypto/x509"
	"crypto/x509/pkix"
	"math/big"
	"time"
)

func GenYkCert(username string) ([]byte, error) {
	crt := &x509.Certificate{
		SerialNumber: big.NewInt(int64(time.Now().Year())),
		Subject: pkix.Name{
			CommonName:         username,
			Country:            []string{"RU"},
			Province:           []string{"Moscow"},
			Locality:           []string{"Moscow"},
			Organization:       []string{"Yandex"},
			OrganizationalUnit: []string{"Infra"},
		},
		NotBefore:             time.Now().Add(-5 * time.Minute),
		NotAfter:              time.Now().AddDate(1, 0, 0),
		IsCA:                  true,
		ExtKeyUsage:           []x509.ExtKeyUsage{x509.ExtKeyUsageClientAuth},
		KeyUsage:              x509.KeyUsageDigitalSignature | x509.KeyUsageCertSign,
		BasicConstraintsValid: true,
	}

	privKey, err := rsa.GenerateKey(rand.Reader, 2048)
	if err != nil {
		return nil, err
	}

	out, err := x509.CreateCertificate(rand.Reader, crt, crt, &privKey.PublicKey, privKey)
	if err != nil {
		return nil, err
	}

	return out, nil
}
