package crt

import (
	"crypto/tls"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/certifi"
)

func HTTPClient() *resty.Client {
	httpc := resty.New().
		SetDebug(true).
		SetBaseURL("https://crt.cloud.yandex.net")

	certPool, err := certifi.NewCertPool()
	if err == nil {
		httpc.SetTLSClientConfig(&tls.Config{RootCAs: certPool})
	}

	return httpc
}
