package main

import (
	"context"
	"flag"
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"a.yandex-team.ru/library/ticket_parser2/go/tvmtool"
	"a.yandex-team.ru/yp/go/yp"
)

func main() {
	var oauthToken string
	flag.StringVar(&oauthToken, "token", "", "oauth token to use")
	flag.Parse()

	zlog, err := zap.New(zap.ConsoleConfig(log.DebugLevel))
	if err != nil {
		panic(err)
	}

	tvmClient, err := tvmtool.NewDeployClient(tvmtool.WithLogger(zlog))
	if err != nil {
		panic(err)
	}

	bbClient, err := httpbb.NewIntranet(httpbb.WithTVM(tvmClient), httpbb.WithLogger(zlog))
	if err != nil {
		panic(err)
	}

	ypClient, err := yp.NewClient("xdc", yp.WithLogger(zlog))
	if err != nil {
		panic(err)
	}
	defer ypClient.Close()

	bbRsp, err := bbClient.OAuth(context.Background(), blackbox.OAuthRequest{
		OAuthToken:    oauthToken,
		UserIP:        "2.2.1.1",
		GetUserTicket: true,
	})
	if err != nil {
		panic(err)
	}

	fmt.Println("used oauth token with scopes:", bbRsp.Scopes)
	fmt.Println("used TVM user-ticket:", bbRsp.UserTicket)
	_, err = ypClient.GetStage(
		yp.WithCredentials(
			context.Background(),
			&yp.UserTicketCredentials{Ticket: bbRsp.UserTicket},
		),
		yp.GetStageRequest{
			ID:     "buglloc-test-stage",
			Format: yp.PayloadFormatYson,
		},
	)
	if err != nil {
		panic(err)
	}

	fmt.Println("YP successfully accepts user-ticket")
}
