import base64
import os
from yp.client import YpClient
from yp_proto.yp.client.api.proto import cluster_api_pb2
from google.protobuf import text_format

CLUSTER = 'sas'
TOKEN = os.environ['YP_TOKEN']

def main():
    client = YpClient(address=CLUSTER, config={'token': TOKEN})
    pod_set_id = client.create_object(object_type='pod_set')
    print('created pod_set: %s' % pod_set_id)

    iss_payload = cluster_api_pb2.HostConfiguration()
    with open('iss.payload', 'rt') as f:
        text_format.Parse(f.read(), iss_payload)

    meta = {
        'pod_set_id': pod_set_id,
        'inherit_acl': True,
        'acl': [
            {
                'action': 'allow',
                'subjects': [
                    'root',
                    'buglloc',
                    'robot-yadi'
                ]
            }
        ]
    }

    spec = {
        'enable_scheduling': True,
        'iss_payload': iss_payload.SerializeToString(),
        'resource_requests': {
            'anonymous_memory_limit': 0,
            'dirty_memory_limit': 0,
            'memory_guarantee': 536870912,
            'memory_limit': 536870912,
            'vcpu_guarantee': 1000,
            'vcpu_limit': 1000
        },
        'ip6_address_requests': [
            {
                'enable_dns': False,
                'network_id': '_SECURITY_MTN_NETS_',
                'vlan_id': 'fastbone'
            },
            {
                'enable_dns': True,
                'network_id': '_SECURITY_MTN_NETS_',
                'vlan_id': 'backbone'
            }
        ],
        'disk_volume_requests': [
            {
                'id': 'i5uk7ngfxkyli5it-q2fdenrv6ym34qgs',
                'labels': {
                    'mount_path': '/',
                    'root_fs_snapshot_quota': 1048576000,
                    'volume_type': 'root_fs',
                    'work_dir_snapshot_quota': 1048576000
                },
                'quota_policy': {
                    'capacity': 20971520000
                },
                'storage_class': 'hdd'
            },
        ],
    }
    labels = {
        'nanny_service_id': 'buglloc-yp',
        'nanny_version': 'f56a147d-1dc0-4482-8abc-c064fe98971a'
    }
    pod_id = client.create_object(object_type='pod', attributes={
        'meta': meta,
        'spec': spec,
        'labels': labels,
    })
    print('created pod: %s' % pod_id)

