package commands

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

var logger log.Logger

var rootCmd = &cobra.Command{
	Use:          "releaser",
	SilenceUsage: true,
	PersistentPreRunE: func(cmd *cobra.Command, _ []string) error {
		var err error
		logger, err = zap.New(zap.KVConfig(log.DebugLevel))
		if err != nil {
			return fmt.Errorf("can't create logger: %w", err)
		}

		return nil
	},
}

func Execute() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}

func init() {
	rootCmd.AddCommand(
		toolsCmd,
		npmCmd,
		pypiCmd,
		versionCmd,
	)
}
