package commands

import (
	"errors"
	"os"

	"github.com/spf13/cobra"
)

var toolsAuthToken string

var toolsCmd = &cobra.Command{
	Use: "tools",
}

func setSecToolsToken(cmd *cobra.Command, args []string) error {
	toolsAuthToken = os.Getenv("SECTOOLS_TOKEN")
	if toolsAuthToken == "" {
		return errors.New("no env[SECTOOLS_TOKEN]")
	}
	return nil
}

func init() {
	toolsCmd.AddCommand(
		toolsUploadCmd,
		toolsReleaseCmd,
	)
}
