package commands

import (
	"context"
	"errors"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/sectools/pkg/sectools"
)

var toolsReleaseCmdArgs struct {
	Name     string
	Version  string
	Channel  string
	Upstream string
}

var toolsReleaseCmd = &cobra.Command{
	Use:     "release",
	PreRunE: setSecToolsToken,
	RunE: func(_ *cobra.Command, args []string) error {
		if toolsReleaseCmdArgs.Version == "" {
			return errors.New("empty version")
		}

		svc, err := sectools.NewService(
			sectools.WithUpstream(toolsReleaseCmdArgs.Upstream),
			sectools.WithAuthToken(toolsAuthToken),
		)
		if err != nil {
			return err
		}

		return svc.Release(
			context.Background(),
			toolsReleaseCmdArgs.Name,
			toolsReleaseCmdArgs.Version,
			sectools.Channel(toolsReleaseCmdArgs.Channel),
		)
	},
}

func init() {
	flags := toolsReleaseCmd.PersistentFlags()
	flags.StringVar(&toolsReleaseCmdArgs.Name, "name", "", "tool name")
	flags.StringVar(&toolsReleaseCmdArgs.Version, "version", "", "version to release")
	flags.StringVar(&toolsReleaseCmdArgs.Channel, "channel", "", "channel to release (stable, prestable, testing)")
	flags.StringVar(&toolsReleaseCmdArgs.Upstream, "upstream", sectools.DefaultUpstream, "sectools upstream")
}
