package commands

import (
	"flag"
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/sectools/internal/config"
)

var (
	cfgPath = "./app.yaml"
	cfg     *config.Config
)

var rootCmd = &cobra.Command{
	Use:          "sectools-web",
	SilenceUsage: true,
	PersistentPreRunE: func(cmd *cobra.Command, args []string) (err error) {
		flag.StringVar(&cfgPath, "cfg", cfgPath, "config path")
		flag.Parse()

		cfg, err = config.LoadConfig(cfgPath)
		if err != nil {
			err = fmt.Errorf("failed to load config: %w", err)
			return fmt.Errorf("failed to load config: %w", err)
		}
		return
	},
}

func Execute() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}

func init() {
	flags := rootCmd.PersistentFlags()
	flags.StringVar(&cfgPath, "cfg", cfgPath, "config path")

	rootCmd.AddCommand(startCmd)
}
