package filespec

import (
	"errors"
	"strings"
)

type FileSpec struct {
	Platform string
	Arch     string
	Filepath string
}

func Parse(spec string) (FileSpec, error) {
	parts := strings.SplitN(spec, ":", 2)
	if len(parts) != 2 {
		return FileSpec{}, errors.New("invalid file spec (must be 'os-arc:/file/path')")
	}

	osarch, filePath := parts[0], parts[1]
	parts = strings.Split(osarch, "-")
	platform, arch := parts[0], "amd64"
	if len(parts) > 1 {
		arch = parts[1]
	}

	return FileSpec{
		Platform: platform,
		Arch:     arch,
		Filepath: filePath,
	}, nil
}
