package fsutil

import (
	"io"
	"os"
)

func CopyFile(from, to string) error {
	srcMode, err := os.Stat(from)
	if err != nil {
		return err
	}

	src, err := os.Open(from)
	if err != nil {
		return err
	}
	defer func() { _ = src.Close() }()

	dst, err := os.Create(to)
	if err != nil {
		return err
	}
	defer func() { _ = dst.Close() }()

	_, err = io.Copy(dst, src)
	if err != nil {
		_ = os.Remove(to)
		return err
	}

	err = os.Chmod(dst.Name(), srcMode.Mode())
	if err != nil {
		_ = os.Remove(to)
		return err
	}

	return nil
}
