package releasers

import "a.yandex-team.ru/security/sectools/internal/config"

type Releasers struct {
	releasers map[string]map[string]struct{}
}

func NewReleasers(releasers []config.Releaser) *Releasers {
	processed := make(map[string]map[string]struct{})
	for _, releaser := range releasers {
		for _, tool := range releaser.Tools {
			if _, ok := processed[tool]; !ok {
				processed[tool] = make(map[string]struct{})
			}

			for _, login := range releaser.Logins {
				processed[tool][login] = struct{}{}
			}
		}
	}

	return &Releasers{
		releasers: processed,
	}
}

func (r *Releasers) IsToolReleaser(toolName, login string) bool {
	_, ok := r.releasers[toolName][login]
	return ok
}
