package common

import (
	"context"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/core/buildinfo"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"a.yandex-team.ru/security/sectools/internal/server/controller"
	"a.yandex-team.ru/security/sectools/internal/server/infra"
)

type Common struct {
	*infra.Infra
}

func NewController(i *infra.Infra) (controller.Controller, error) {
	return &Common{
		Infra: i,
	}, nil
}

func (c *Common) BuildRoute(_ string, g *echo.Group) {
	g.GET("/ping", func(e echo.Context) error {
		if _, err := c.TVM.GetServiceTicketForID(e.Request().Context(), httpbb.IntranetEnvironment.TvmID); err != nil {
			return err
		}

		return e.String(http.StatusOK, "pong")
	})

	g.GET("/version", func(c echo.Context) error {
		return c.String(200, buildinfo.Info.ProgramVersion)
	})
}

func (c *Common) Shutdown(_ context.Context) {

}
