package pages

import (
	"context"
	"net/http"
	"strings"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/sectools/internal/server/controller"
	"a.yandex-team.ru/security/sectools/internal/server/infra"
	"a.yandex-team.ru/security/sectools/pkg/sectools"
)

type Pages struct {
	*infra.Infra
}

func NewController(infra *infra.Infra) (controller.Controller, error) {
	return &Pages{
		Infra: infra,
	}, nil
}

func (p *Pages) BuildRoute(_ string, g *echo.Group) {
	g.GET("/", p.indexPage)
	g.GET("/:tool", p.toolPage)
	g.GET("/download/:tool/:version/:platform/:arch/:filename", p.downloadPage)
}

func (p *Pages) Shutdown(_ context.Context) {

}

func (p *Pages) indexPage(c echo.Context) error {
	return c.Render(http.StatusOK, "index.html", echo.Map{
		"Channel": sectools.ChannelStable,
		"Tools":   p.Tools.List(),
	})
}

func (p *Pages) toolPage(c echo.Context) error {
	tool, ok := p.Tools.Tool(c.Param("tool"))
	if !ok {
		return renderNotFound(c)
	}

	return c.Render(http.StatusOK, "tool.html", echo.Map{
		"Subtitle": strings.Title(tool.Name),
		"Tool":     tool,
	})
}

func (p *Pages) downloadPage(c echo.Context) error {
	return c.String(200, "ss")
}

func renderNotFound(c echo.Context) error {
	return c.Render(http.StatusNotFound, "error.html", nil)
}
