package static

import (
	"context"
	"fmt"
	"net/http"
	"strings"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/sectools/assets"
	"a.yandex-team.ru/security/sectools/internal/server/controller"
	"a.yandex-team.ru/security/sectools/internal/server/infra"
)

type Static struct {
}

func NewController(_ *infra.Infra) (controller.Controller, error) {
	return &Static{}, nil
}

func (s *Static) BuildRoute(prefix string, g *echo.Group) {
	prefix = fmt.Sprintf("/%s/", strings.Trim(prefix, "/"))
	g.GET("/*", echo.WrapHandler(
		http.StripPrefix(
			prefix,
			http.FileServer(http.FS(assets.StaticFS())),
		)),
	)
}

func (s *Static) Shutdown(_ context.Context) {

}
