package server

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/sectools/internal/server/infra"
)

func newHTTPErrorHandler(i *infra.Infra) func(err error, c echo.Context) {
	return func(err error, c echo.Context) {
		i.Logger.Error("request error", log.String("uri", c.Request().URL.String()), log.Error(err))

		var (
			code = http.StatusInternalServerError
			msg  interface{}
		)

		if he, ok := err.(*echo.HTTPError); ok {
			code = he.Code
			msg = he.Message
		} else {
			msg = err.Error()
		}

		if _, ok := msg.(string); ok {
			msg = echo.Map{"error": msg}
		} else {
			msg = echo.Map{"error": "unknown"}
		}

		// Send response
		if !c.Response().Committed {
			if c.Request().Method == http.MethodHead { // Issue #608
				_ = c.NoContent(code)
			} else {
				_ = c.JSON(code, msg)
			}
		}
	}
}
