package sectools

type Option func(*Service)

func WithUpstream(upstream string) Option {
	return func(service *Service) {
		service.httpc.SetBaseURL(upstream)
	}
}

func WithAuthToken(token string) Option {
	return func(service *Service) {
		service.httpc.SetHeader("Authorization", "OAuth "+token)
	}
}
