package sectools

import "fmt"

type Channel string

const (
	ChannelNone      Channel = ""
	ChannelStable    Channel = "stable"
	ChannelPrestable Channel = "prestable"
	ChannelTesting   Channel = "testing"
)

func ParseChannel(c string) (Channel, error) {
	switch c {
	case "stable":
		return ChannelStable, nil
	case "prestable":
		return ChannelPrestable, nil
	case "testing":
		return ChannelTesting, nil
	}

	return ChannelNone, fmt.Errorf("unknown channel: %s", c)
}

type DownloadInfo struct {
	URL     string `json:"url"`
	FastURL string `json:"fast_url"`
	DumbURL string `json:"dumb_url"`
	Size    int    `json:"size"`
	Hash    string `json:"hash"`
}

type Platform = string
type Arch = string
type BinariesMap = map[Platform]map[Arch]DownloadInfo

type Manifest struct {
	Version  string      `json:"version"`
	Binaries BinariesMap `json:"binaries"`
}

type Tool struct {
	Name     string `json:"name"`
	Version  string `json:"version"`
	Platform string `json:"platform"`
	Arch     string `json:"arch"`
}

type UploadedTool struct {
	Tool
	DownloadInfo
}

type UploadedManifest struct {
	Manifest
	DownloadInfo
}
