#!/usr/bin/env node
const childProcess = require('child_process');
const bin = require('.');

try {
    childProcess.execFileSync(
        bin.binaryPath(),
        process.argv.slice(2),
        { stdio: 'inherit', encoding: 'utf8' });
} catch (e) {
    if (typeof e.status !== 'undefined' && e.status !== null) {
        // ignore node.js underlying error
        process.exit(e.status);
    } else {
        console.error(e);
        process.exit(1);
    }
}
