const path = require('path');
const fs = require('fs');

const binaryNames = {
    darwin: 'osx_@@tool@@',
    linux: 'nix_@@tool@@',
    win32: 'win_@@tool@@.exe'
};

function binaryPath() {
    const out = path.join(__dirname, 'vendor', binaryNames[process.platform]);
    if (!fs.existsSync(out)) {
        throw `file ${out} doesn't exists`;
    }

    return out;
}

exports.binaryNames = binaryNames;
exports.binaryPath = binaryPath;
