package templates

type Option func(*Builder)

func WithToolName(name string) Option {
	return func(b *Builder) {
		b.toolName = name
	}
}

func WithPackageName(name string) Option {
	return func(b *Builder) {
		b.packageName = name
	}
}

func WithVersion(version string) Option {
	return func(b *Builder) {
		b.version = version
	}
}

func WithAuthor(name, email string) Option {
	return func(b *Builder) {
		b.authorName = name
		b.authorEmail = email
	}
}
