import sys

DST_MAP = {
    'linux': 'nix_@@tool@@',
    'windows': 'win_@@tool@@.exe',
    'darwin': 'osx_@@tool@@'
}

def path(target_platform=None):
    return DST_MAP[target_platform or platform()]

def platform():
    if sys.platform == 'linux' or sys.platform == 'linux2':
        return 'linux'
    elif sys.platform == 'darwin':
        return 'darwin'
    elif sys.platform == 'win32':
        return 'windows'
    else:
        raise Exception('Failed to determine system platform: %s' % platform)
