import os
from setuptools import setup
from setuptools.command.install import install
from @@pkg@@ import binary, version

try:
    from urllib.request import urlretrieve
    from email.utils import parseaddr as parse_author
except ImportError as e:
    # Python 2
    from urllib import urlretrieve
    from email.Utils import parseaddr as parse_author

PKG_NAME = '@@pkg@@'
AUTHOR = '@@author@@'
TARGET_PLATFORM = os.environ.get('TARGET_PLATFORM', None)
DEFAULTS = {
    'repl': {
        'linux': 'manylinux1_x86_64',
        'windows': 'win_amd64',
        'darwin': '.'.join('macosx_{ver}_intel.macosx_{ver}_x86_64'.format(ver=v.replace('.', '_'))
            for v in ['10.14', '10.15', '11.0', '12.0'])
    },
    'platform': {
        'linux': 'linux',
        'windows': 'windows',
        'darwin': 'darwin'
    }
}

cmdclass = {}
try:
    from wheel.bdist_wheel import bdist_wheel

    class ForcedWheelTags(bdist_wheel, object):
        def get_tag(self):
            orig_tag = super(ForcedWheelTags, self).get_tag()
            repl = self._forced_repl()
            if not repl:
                return orig_tag

            tag = (orig_tag[0], orig_tag[1], repl)
            print('Switched tag from: "{}" to "{}"'.format('-'.join(orig_tag), '-'.join(tag)))
            return tag

        def _forced_repl(self):
            if not TARGET_PLATFORM:
                return None
            return DEFAULTS.get('repl', {}).get(TARGET_PLATFORM, None)

    cmdclass['bdist_wheel'] = ForcedWheelTags
except ImportError:
    pass


def package_data():
    if not TARGET_PLATFORM:
        return ['vendor/*']

    return ['vendor/readme.txt', 'vendor/' + binary.DST_MAP[DEFAULTS.get('platform', {}).get(TARGET_PLATFORM, None)]]


author, author_email = parse_author(AUTHOR)
setup(
    name=PKG_NAME,
    version=version.LATEST,
    description='@@tool@@ wrapper that makes it seamlessly available as a local dependency',
    author=author,
    author_email=author_email,
    entry_points={
        'console_scripts': ['@@tool@@=%s.main:main' % PKG_NAME],
    },
    packages=[PKG_NAME],
    package_data={PKG_NAME: package_data()},
    classifiers=[
        'Environment :: Console',
        'Intended Audience :: Developers',
    ],
    cmdclass=cmdclass,
)
