package idm

import (
	"crypto/tls"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/certifi"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/nop"
	"a.yandex-team.ru/library/go/core/xerrors"
)

const (
	DefaultHost = "https://idm-api.yandex-team.ru"
)

type Client struct {
	host       string
	authToken  string
	httpClient *resty.Client
	logger     log.Structured
}

func NewClient(authToken string, opts ...Option) (*Client, error) {
	certPool, err := certifi.NewCertPool()
	if err != nil {
		return nil, xerrors.Errorf("failed to initialize cert pool: %w", err)
	}
	r := resty.New().
		SetTLSClientConfig(&tls.Config{RootCAs: certPool}).
		SetRetryCount(5).
		SetRedirectPolicy(resty.NoRedirectPolicy()).
		SetBaseURL(DefaultHost).
		SetHeader("Authorization", "OAuth "+authToken).
		SetHeader("User-Agent", "SicIDMClient <security@yandex-team.ru>")

	c := &Client{
		authToken:  authToken,
		httpClient: r,
		host:       DefaultHost,
		logger:     &nop.Logger{},
	}

	for _, opt := range opts {
		opt(c)
	}

	return c, nil
}
