package idm

import (
	"time"

	"a.yandex-team.ru/library/go/core/log"
)

type Option func(client *Client)

func WithRetries(retries int) Option {
	return func(client *Client) {
		client.httpClient.SetRetryCount(retries)
	}
}

func WithTimeout(timeout time.Duration) Option {
	return func(client *Client) {
		client.httpClient.SetTimeout(timeout)
	}
}

func WithHost(hostURI string) Option {
	return func(client *Client) {
		client.host = hostURI
		client.httpClient.SetBaseURL(hostURI)
	}
}

func WithLogger(logger log.Structured) Option {
	return func(client *Client) {
		client.logger = logger
		client.httpClient.SetDebug(true)
		client.httpClient.SetLogger(logger.Fmt())
	}
}

func WithDebug(debug bool) Option {
	return func(client *Client) {
		client.httpClient.SetDebug(debug)
	}
}
