package commands

import (
	"errors"
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/skotty/datalens-exporter/internal/app"
	"a.yandex-team.ru/security/skotty/datalens-exporter/internal/config"
)

var exportCmd = &cobra.Command{
	Use:          "export",
	SilenceUsage: true,
	Short:        "one-shot export",
	RunE: func(_ *cobra.Command, _ []string) error {
		if rootArgs.ConfigPath == "" {
			return errors.New("--config is empty")
		}

		cfg, err := config.Load(rootArgs.ConfigPath)
		if err != nil {
			return fmt.Errorf("failed to parse config: %w", err)
		}

		instance, err := app.NewApp(cfg)
		if err != nil {
			return fmt.Errorf("failed to create application: %w", err)
		}

		return instance.Export()
	},
}
