package commands

import (
	"github.com/spf13/cobra"
)

var rootArgs struct {
	ConfigPath string
}

var rootCmd = &cobra.Command{
	Use:          "datalens-exporter",
	SilenceUsage: true,
	Short:        "Skotty -> Datalens exporter",
}

func Execute() error {
	return rootCmd.Execute()
}

func init() {
	rootCmd.PersistentFlags().StringVar(&rootArgs.ConfigPath, "config", "", "path to config")

	rootCmd.AddCommand(
		startCmd,
		exportCmd,
	)
}
