package exportdb

import (
	"fmt"
)

func upsertUsersQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");
DECLARE $users AS List<Struct<
    login: Utf8,
	have_ssh_keys: Bool,
	enrolled: Bool,
	department: Utf8,
	enrolled_at: Datetime>>;

UPSERT INTO	users_tmp
SELECT login, have_ssh_keys, department, enrolled, enrolled_at FROM AS_TABLE($users)
;
`, pathPrefix)
}

func upsertDepartmentsQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");
DECLARE $departments AS List<Struct<
    login: Utf8,
    department: Utf8>>;

UPSERT INTO	departments_tmp
SELECT login, department FROM AS_TABLE($departments)
;
`, pathPrefix)
}

func upsertACLQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");
DECLARE $acl AS List<Struct<
    login: Utf8,
	head_uid: Uint64>>;

UPSERT INTO	acl_tmp
SELECT login, head_uid FROM AS_TABLE($acl)
;
`, pathPrefix)
}

func upsertTotalUsersQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");
DECLARE $date AS DateTime;
DECLARE $count AS Int32;

UPSERT INTO	total_users
	(check_date, count)
VALUES
	($date, $count)
;
`, pathPrefix)
}

func createTemporaryTablesQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");

CREATE TABLE users_tmp
(
    login         Utf8,
	have_ssh_keys Bool,
	department    Utf8,
	enrolled      Bool,
	enrolled_at   Datetime,

	PRIMARY KEY   (login)
);

CREATE TABLE departments_tmp
(
    login       Utf8,
	department  Utf8,

	PRIMARY KEY (login, department)
);

CREATE TABLE acl_tmp
(
	login     Utf8,
	head_uid Uint64,

	PRIMARY KEY (login, head_uid)
);
`, pathPrefix)
}

func createTablesQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");

CREATE TABLE total_users
(
	check_date  Datetime,
	count Int32,

	PRIMARY KEY (check_date)
);
`, pathPrefix)
}

func dropTemporaryUsersQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");

DROP TABLE users_tmp;
`, pathPrefix)
}

func dropTemporaryACLQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");

DROP TABLE acl_tmp;
`, pathPrefix)
}

func dropTemporaryDepartmentsQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");

DROP TABLE departments_tmp;
`, pathPrefix)
}

func renameTablesQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");

DROP TABLE users;
ALTER TABLE users_tmp RENAME TO users;
DROP TABLE acl;
ALTER TABLE acl_tmp RENAME TO acl;
DROP TABLE departments;
ALTER TABLE departments_tmp RENAME TO departments;
`, pathPrefix)
}
