package models

import "time"

type YubiToken struct {
	User      string    `json:"user"`
	CreatedAt time.Time `json:"created_at"`
}

type UserInfo struct {
	Login          string    `json:"login"`
	HaveYCloudKeys bool      `json:"have_ycloud_keys"`
	HaveSSHKeys    bool      `json:"have_ssh_keys"`
	Department     string    `json:"department"`
	Enrolled       bool      `json:"enrolled"`
	EnrolledAt     time.Time `json:"enrolled_at,omitempty"`
}

type ACL struct {
	Login   string `json:"login"`
	HeadUID uint64 `json:"head_uid"`
}

type Department struct {
	Login      string `json:"login"`
	Department string `json:"department"`
}
