package skottydb

import (
	"fmt"
)

func lookupYubikeyTokensQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");
DECLARE $tokenType AS Uint8;
DECLARE $tokenState AS Uint8;
DECLARE $lastUser AS Utf8;
DECLARE	$lastId AS Utf8;
DECLARE	$lastEnrollId AS Utf8;
DECLARE $limit AS Uint64;

$curTokens = (
	SELECT
		created_at, user, id, enroll_id
	FROM
		tokens
	WHERE
		user = $lastUser AND id = $lastId AND enroll_id > $lastEnrollId AND token_type = $tokenType AND token_state = $tokenState
	LIMIT $limit
);

$nextTokens = (
	SELECT
		created_at, user, id, enroll_id
	FROM
		tokens
	WHERE
		user > $lastUser AND token_type = $tokenType AND token_state = $tokenState
	LIMIT $limit
);

$allTokens = (SELECT * FROM $curTokens UNION ALL SELECT * FROM $nextTokens);
SELECT created_at, user, id, enroll_id FROM $allTokens ORDER BY user LIMIT $limit;
`, pathPrefix)
}
