package splunk

import "a.yandex-team.ru/library/go/core/log"

type Option func(sender *HecSender)

func WithAuthToken(token string) Option {
	return func(sender *HecSender) {
		sender.httpc.SetHeader("Authorization", "Splunk "+token)
	}
}

func WithLogger(l log.Logger) Option {
	return func(sender *HecSender) {
		sender.l = l
		sender.httpc.SetLogger(log.With(l, log.String("source", "splunk_sender")).Fmt())
	}
}
