package staff

type User struct {
	Login            string
	UID              uint64
	SSHFingerprints  []string
	MainDepartmentID string
	MainDepartment   string
	Heads            []uint64
	DepartmentsIDs   []string
	Departments      []string
}

type staffErrorResponse struct {
	Msg string `json:"error_message"`
}

type staffResponse struct {
	Links struct {
		Next string `json:"next"`
	} `json:"links"`
}

type staffPersonsResponse struct {
	staffResponse
	Result []struct {
		Login  string `json:"login"`
		UID    uint64 `json:"uid,string"`
		Chiefs []struct {
			UID uint64 `json:"uid,string"`
		} `json:"chiefs"`
		DepartmentGroup struct {
			staffDepartment
			Ancestors []staffDepartment `json:"ancestors"`
		} `json:"department_group"`
		Keys []struct {
			Fingerprint string `json:"fingerprint_sha256"`
		} `json:"keys"`
	} `json:"result"`
}

type staffDepartment struct {
	Name string `json:"name"`
	URL  string `json:"url"`
}

type staffGroupMembershipResponse struct {
	staffResponse
	Result []struct {
		Person struct {
			Login string `json:"login"`
		} `json:"person"`
	} `json:"result"`
}
