# How it works: CA keys

Т.к. вся безопасность так или иначе сводится к безопасности CA, его ключи ротируются раз в год [TODO(buglloc): событие в infra].
Ротируемость важна по нескольким причинам:
  - потребители (cauth/portoshell/etc) обязаны научиться в ротацию :) Т.е. уметь периодически ходить за свежими публичными ключами, это позволит в случае факапа менее болезненно отреагировать на ситуацию, т.к. механизм ротации будет отработан
  - так же, как и с пользовательскими сертификатами, уменьшает последствия от кражи приватной части ключа и/или делает этот процесс более шумным

Для того, что бы ничего от ротации не сложилось применяется следующий алгоритм:
  1. при вводе Skotty в эксплуатацию были сгенерированы две пары ключей на каждый CA (`current` и `next`):
    * `current` всегда используется для выписывания пользовательских сертификатов
    * `next` используется только в качестве доверенного ключа (Skotty даже не имеет его приватной части до часа X)
    * потребители должны верить `current` и `next` публичным ключам CA, их Skotty отдает в соответствующих ручках
  2. спустя 8 месяцев, от начала использования `current`, пары инженер ротирует их:
    * `current` пары становится `prev`, на них больше ничего не выписывается, но они продолжают использоваться как доверенные
    * `next` пары становятся `current` (подкладываются их приватные ключи и т.д.), на них теперь будут выписываться сертификаты
    * генерятся новые пары `next`, так же не отдавая приватную часть в прод
  3. спустя год от начала использования старенькой `current` пары она удаляется окончательно. К этому моменту "живых" сертификатов остаться не должно
  4. переходим к п.2

Таким образом:
   - в случае мегафакапа у нас всегда есть запасная пара ключей, которую можно ввести в эксплуатацию. А благодаря тому, что её публичную часть мы начали выдавать заранее - осталось только перевыпустить пользовательские сертификаты
   - ротация не должна "сломать" потребителей, т.к. у них есть до года на обновление публичных ключей (но лучше не делать синк реже раза в неделю, конечно)
   - ротация не должна "сломать" пользователей, т.к. к моменту вымывания `prev` пар "живых" сертификатов на руках быть не должно (максимальный срок жизни пользовательского сертификата - 3 месяца)