# How it works: enroll и renew

Для начала, давайте определимся что есть что:
  - `enroll` - первичная инициализация Yubikey в рамках которой:
    * генерируются все приватные ключи: `renew` + `secure` + `insecure` + `legacy` + `sudo`
    * Yubikey привязывается к вашему аккаунту. В случае, если он уже был кем-то использован - перепривязывается, а все ранее выписанные для него сертификаты отзываются
    * на Certificate Authority Skotty (у каждого типа ключа он свой) выписываются x509/ssh сертификаты
  - `renew` - обновление сертификатов, причем:
    * `legacy` ключ в этом процессе никак не учавствует, поэтому не будет испорчен
    * обновление разрешенно только для того же yubikey на котором был произведен `enroll`

Т.к. по своему смыслу `enroll` и `renew` операции разного порядка, плюс на момент `renew` мы знаем значительно больше о его владельце, для этих операций доступны разные способы аутентификации/авторизации:
  - `enroll` - разрешено делать только через прохождение полноценной web-аутентификации
  - `renew` - можно подтверждать `renew` ключем, если таковой возможности нет - web-аутентификация

## Enroll

Технически `enroll` устроен следующим образом:
  - skotty генерирует все 5 приватных ключей
  - получает аттестационный сертификат yubikey + по аттестационному сертификату на каждый ключ
  - идет в API и начинает процесс энроллмента
  - серверная часть проверяет, что запрос корректный и возвращает:
    * JWT токен для поллинга
    * аутентификационный/энрольный ID
    * URL для прохождения web-аутентификации
  - skotty просит пользователя перейти по полученному URL-адресу и начинает поллить возможность выписать сертификаты
  - пользователь переходит по URL-адресу и подтверждает требуемое действие (в текущем случае - `enroll`)
  - после этого, серверная часть разрешает skotty получить сертификаты, при этом:
    * благодаря наличию аттестационного сертификата yubikey, проверяет, что это точно он
    * на основе аттестационных сертификатов ключей проверяет политики доступа к оным
    * если все хорошо:
      - выписывает сертификаты
      - привязывает yubikey к вашему аккаунту, а предыдущий (т.е. с тем же серийным номером) отзывает
      - генерирует JWT токен для обновления сертификатов в будущем
  - теперь skotty, получив все это богатство, обновляет информацию о сертификатах, конфиг и благодарит вас за проделанную работу

Текущая схема позволяет:
  - не запрашивать у вас доменный пароль, логин и прочее
  - реализовать MFA
  - переиспользовать yubikey, даже если он по какой-то причине не был отозван после сдачи предыдущим владельцем
  - позволяет полуавтоматически/вручную обновить сертификаты

## Renew

`renew` работает очень схожим образом, но гораздо проще:
  - skotty берет информацию о последнем энролле (из конфига или сертификата)
  - идет в API и начинает процесс обновления
  - если у него имеется `renew` ключ - тут же подтверждает операцию
  - если его нет/он истек/не валиден - просит пройти web-аутентификацию, как при энроллменте
  - в случае успеха - серверная часть выписывает сертификаты, а skotty их обновляет
  - все.

Если у вас возник вопрос, зачем нужен отдельный `renew` ключ, то:
  - если использовать один из существующий ключей, то всегда есть шанс, что им получится подписать renew запрос при его форвардинге
  - если ничем не подписывать запрос (или использовать что-либо с fs), то мы возвращаемся к вопросу о не экспортируемости приватной части ключа
  - если ограничиться только аттестационным сертификатом yubikey, то можно будет, сперев его, получить ваши ключи

