# Why?!

Если вы не понимаете почему Skotty сфокусирован на хардварных токенах, этот раздел должен чуть прояснить.

## Не экспортируемость приватной части ключа
Покуда у пользователя есть доступ к приватной части ключа (будь то encrypted или нет), он регулярно перетекает на различные dev-тачки, переносится между рабочими/личными устройствами и т.д.
Все это сильно увеличивает attack surface, ибо нет никаких гарантий, что SSH-ключ пользователя тупо не будет кем-нибудь найден (будь то "внутренний нарушитель" или малварь). В случае с хардварным токеном ключи будут генерироваться внутри токена и никогда не будут его покидать. Его нельзя будет извлечь, сложить на фс, скопировать на dev-тачку, утащить малварью и т.д.

## Необходимость закрепления для злоумышленника
За счет невозможности извлечь приватную часть ключа (см. выше) и использовать из другого места, злоумышленнику нужно будет организовывать persistence на рабочей станции пользователя. Т.е. для совершения каких-либо действий от имени пользователя злоумышленник должен "сидеть" на его тачке, учиться переживать перезагрузки и пр. С нашей стороны это сильно повышает вероятность обнаружения подобного заражения, а для злоумышленника - сильно сужает окно возможностей.

## Why passwordless sudo?
Сейчас парольное sudo работает поверх sssd, который ходит в ldap `cauth[0-9]*.yandex.net`. Т.е. пользователь вводит свой доменый пароль, который проверяется лдапом.
Из этого вытекает две проблемы:
  - пользователь вводит свой пароль на потенциально похаченной тачке. Если представить ситуацию, что злоумышленник подхачил тачку:
    * на неё приходит SRE/Devops подебажить проблемы с оной
    * вводит свой доменный пароль
    * злоумышленник получает пароль для дальнейшего развития атаки
  - он позволяет брутить доменные пароли. При этом, т.к. это серверный сегмент - мониторинг и расследование подобных инцидентов сильно усложнены

Skotty предлагает альтернативную аутентификацию пользователя в sudo поверх приватного ключа, хранящегося в токене.

Из плюсов:
  - больше нет паролей и они не нужны в самом ldap

Из минусов:
  - подходит только для sudo
  - требует проброса SSH-agent с соответствующим ключом для работы sudo

О том, как не потерять в безопасности при пробросе сокета для sudo, было рассказано в [настройка SSH: клиентская часть](https://docs.yandex-team.ru/skotty/ssh-client).

## Why yubikey?
Мы рассматривали несколько вариантов:
  - Yubikey
  - TPM в ноутах для GNU/Linux и Windows
  - Secure Enclave для macOS

Наши требования к хорошему хардварному токену:
  1. Поддерживает, как минимум, ecdsa ключи: yubikey + tpm + secure enclave
  2. Поддерживает различные touch policy для ключей: yubikey + secure enclave
  3. Позволяет аттестовать хранимый ключ: yubikey + tpm

Если вы можете научить TPM или Secure Enclave выполнять наши требования - расскажите, плиз :)

## Почему набор требований именно такой?

### ECDSA ключи
  - у них хорошая поддержка как со стороны OpenSSH, так и разнообразных токенов
  - секурность. Так, например, RSA требует все большей длины ключа и скорее всего будет отключен в будущем

### Touch policy
Touch policy (буквально, нужно ли _физически_ трогать токен для разблокировки ключа) нам нужен для усложнения жизни не только пользователю, но и зломышленнику. Суть заключается вот в чем - представим, что злоумышленник находится на одной тачке (будь то рабочая станция или сервер) с SSH-agent, в котором доступны приватные ключи токена:
  - без touch policy: пошел на сервак по SSH, подписал в агенте challenge, попал на сервак
  - с touch policy: обманывай пользователя, чтобы он прикоснулся к токену или жди когда он сам в следующий раз пойдет на сервер => меньше окно для атаки + более шумно => сильно повышает вероятность обнаружения подобного заражения

А за счет того, что обычно touch policy настраивается для каждого ключа отдельно - мы можем контролировать, насколько безопасным должно быть хранение ключа для попадания в ту или иную среду. Так, например, для доступа в dev или vcs, очевидно, нет необходимости включать touch policy, т.к. это слишком отразится на UX.

В случае использования Yubikey, доступны следующие политики:
  - Never - для разблокировки слота касание пользователя не требуется
  - Always - при каждой разблокировке слота (считай подписи ключем) нужно физически потрогать Yubikey
  - Cached - то же самое, что и Always, но с кешированием на 15 секунд

### Аттестация
Аттестация это механизм, позволяющий серверной стороне получить знание о том, как хранится ключ и/или какая у него политика доступа. Обычно выглядит как получение сертификата с информацией о ключе, который выписан на сертификате токена, который подписан сертификатом вендора.
Таким образом, на примере yubikey, серверная сторона может узнать что:
  - ключ действительно хранится в yubikey
  - какая у него pin/touch policy

А уже в зависимости от этих знаний принимать решение о доверии и доступе в ту или иную среду. В нашем случае - на каком CA выписывать пользователю сертификат.

## Почему внешний хардварный токен все еще безопасный?
Иногда можно встретить переживание, нельзя ли будет украденный токен заиспользовать на другой машинке. Отвечаем - в теории можно, на практике:
  - Для всех ключей мы требуем использование PIN (в т.ч. проверяем при аттестации) => украв yubikey нужно знать PIN
  - На ввод PIN в yubikey есть три попытки, после этого только сброс PIN с помощью PUK
  - На ввод PUK есть три попытки, после этого только полный сброс PIV
  - В Yubikey хранится только приватная часть и ее x509 сертификат, публичная часть подписанного SSH-ключа лежит на диске => украв yubikey и узнав PIN нужно иметь и SSH-сертификат с диска. По понятным причинам, мера не ультимативная, но все равно затрудняет несанкционированный доступ при утере/краже yubikey.

Disclaimer: предполагается, что если у вас отключено шифрование диска, то у вас куда большие проблемы.

## Как у других ребят?
В большей степени, все двигаются в направлении:
  - переходят на SSH CA, кто-то более категорично (e.g. зашивают ACL непосредственно в сертификат и на удаленной стороне безоговорочно верят оному), кто-то менее, используя сертификат только для аутентификации. Важно понимать, что обычно для того чтобы на уровне сертификата рулить доступами нужно или иметь кастомный SSH-клиент или микроскопическую инфру или целиком завязать возможность доступа в прод на enroll сервис - всё это не про нас
  - внедряют хардварные токены
  - строят бастионы (aka jump-хосты), расчитывая что смогут
    * их замониторить
    * заимплементить MFA (FIDO2? => хардварный токен)
    * ограничить доступ как из недоверенных сред к Бастиону, так и на конечные хосты в обход Бастиона. Строить Бастион мы (пока?) не хотим, т.к. считаем, что Бастион (или его аналог) - это дополнительная мера к корректному способу аутентификации, а не его замена.

Что можно дополнительно поштырить:
- [YubiKey в Облаке](https://wiki.yandex-team.ru/cloud/yubikey/)
- [How Uber, Facebook, and Netflix Do SSH](https://goteleport.com/blog/how-uber-netflix-facebook-do-ssh/)
- [Using TPMs to Cryptographically Verify Devices at Scale](https://www.youtube.com/watch?v=EmEymlA5Q5Q)
- [Scalable and secure access with SSH](https://engineering.fb.com/2016/09/12/security/scalable-and-secure-access-with-ssh/)
