#!/bin/bash

set -xe

# на всякий :)
/bin/chown root.root -R /etc/ssh

# для начала скачаем ключи CA (вы должны периодически обновлять их, например раз в неделю)
# это CA с требованием потрогать юбикей для доступа
echo '# secure ca' > /etc/ssh/pki/users_ca
/bin/curl https://cauth.yandex.net:4443/keylists/main/secure >> /etc/ssh/pki/users_ca
# этот без
echo '# insecure ca' >> /etc/ssh/pki/users_ca
/bin/curl https://cauth.yandex.net:4443/keylists/main/insecure >> /etc/ssh/pki/users_ca

# KRL для проверки отзыва сертификатов (вы должны периодически обновлять его)
/bin/curl https://cauth.yandex.net:4443/keylists/main/all.zst | zstd -d > /etc/ssh/pki/users_krl

# теперь разберемся с пользователями, у нас их для примера два
# обычный котан
CAT_LOGIN="${CAT_LOGIN:=cat}"
# созданим рандомного котана
/sbin/useradd -ms /bin/bash "$CAT_LOGIN"
# добавим его principals, разрешающий входить в него с сертификатом от some-cat
echo "$CAT_LOGIN" > "/etc/ssh/principals/$CAT_LOGIN"

# и супер котан, которому разрешено логиниться в рута
SUPER_CAT_LOGIN="${SUPER_CAT_LOGIN:=supercat}"
# создадим рандомного супер-котана
/sbin/useradd -ms /bin/bash "$SUPER_CAT_LOGIN"
# добавим его principals, разрешающий входить в него с сертификатом от some-cat
echo "$SUPER_CAT_LOGIN" > "/etc/ssh/principals/$SUPER_CAT_LOGIN"
# тажке разрешим ему входить под рутом
echo "$SUPER_CAT_LOGIN" >> /etc/ssh/principals/root

# и стартанем sshd
/sbin/sshd -D
