package main

import (
	"bytes"
	"fmt"
	"os"

	"a.yandex-team.ru/library/go/core/resource"
	"a.yandex-team.ru/security/skotty/launcher/internal/version"
	"a.yandex-team.ru/security/skotty/libs/winres"
)

func winVersion() string {
	patch := uint32(version.Patch())
	return fmt.Sprintf(
		"%d.%d.%d.%d",
		version.Major(),
		version.Minor(),
		uint16(patch>>16),
		uint16(patch),
	)
}

func main() {
	pi := winres.ProgramInfo{
		Name:    "Skotty",
		Version: winVersion(),
	}

	if logo := resource.Get("logo.png"); len(logo) > 0 {
		pi.Logo = bytes.NewReader(logo)
	}

	if err := winres.GenTo(pi, os.Stdout); err != nil {
		panic(err)
	}
}
