//go:build !windows
// +build !windows

package installer

import (
	"errors"
	"fmt"
	"os"
	"os/exec"

	"golang.org/x/sys/unix"
)

const DefaultInstallDir = "/usr/local/bin"

func havePerms(installDir string) bool {
	err := unix.Access(installDir, unix.W_OK)
	return err == nil
}

func updateEnv(_ string) error {
	return nil
}

func raisePermissions(selfExe, installDir string) (bool, error) {
	if _, ok := os.LookupEnv("SKOTTY_INSTALL_DIR"); ok {
		return false, errors.New("permissions already raised")
	}

	// we need root permission so re-execute with sudo
	fmt.Printf("Not enough permissions to skotty launcher install into %q, calling sudo for rescue\n", installDir)
	cmd := exec.Command("sudo", "--", selfExe, "--self-install", "--allow-root")
	cmd.Stdout = os.Stdout
	cmd.Stderr = os.Stderr
	cmd.Env = append(os.Environ(), "SKOTTY_INSTALL_DIR="+installDir)

	return false, cmd.Run()
}
