package version

import (
	"fmt"
	"strconv"

	"a.yandex-team.ru/library/go/core/buildinfo"
)

const (
	major = 0
	minor = 1
)

func Major() int {
	return major
}

func Minor() int {
	return minor
}

func Patch() int {
	raw := buildinfo.Info.ArcadiaSourceRevision
	if raw == "" || raw == "-1" {
		raw = "0"
	}

	out, _ := strconv.Atoi(raw)
	return out
}

func Full() string {
	patch := buildinfo.Info.ArcadiaSourceRevision
	if patch == "" || patch == "-1" {
		patch = "0"
	}

	return fmt.Sprintf("%d.%d.%d", Major(), Minor(), Patch())
}
