package launcher

import (
	"errors"
	"fmt"

	"a.yandex-team.ru/security/skotty/launcher/internal/updater"
)

func LatestExecutable() (string, error) {
	release, err := updater.ReadReleaseInfo()
	if err != nil {
		return "", fmt.Errorf("unable to parse release info: %w", err)
	}

	if release.IsZero() {
		return "", errors.New("no release info available")
	}

	return updater.InReleasesPath(release.Version, updater.BinaryName)
}
