package main

import (
	"encoding/json"
	"os"
	"strings"

	"github.com/spf13/pflag"

	"a.yandex-team.ru/security/skotty/launcher/tools/fake-skotty/runinfo"
)

func main() {
	var exitCode int
	var outPath string
	flags := pflag.NewFlagSet("fake-skotty", pflag.ContinueOnError)
	flags.IntVar(&exitCode, "exit-code", 0, "exit code")
	flags.StringVar(&outPath, "out", os.Getenv("FAKE_SKOTTY_OUTPUT"), "output path")
	flags.ParseErrorsWhitelist.UnknownFlags = true

	if err := flags.Parse(os.Args); err != nil {
		panic(err)
	}

	defer func() { os.Exit(exitCode) }()

	out := runinfo.RunInfo{
		Args: os.Args[1:],
		Env:  make(map[string]string),
	}
	for _, e := range os.Environ() {
		if !strings.HasPrefix(e, "UNDER_LAUNCHER") && !strings.HasPrefix(e, "SKOTTY_") {
			continue
		}

		parts := strings.SplitN(e, "=", 2)
		out.Env[parts[0]] = parts[1]
	}

	ourBytes, err := json.Marshal(out)
	if err != nil {
		panic(err)
	}

	err = os.WriteFile(outPath, ourBytes, 0o644)
	if err != nil {
		panic(err)
	}
}
