package askpass

import (
	"errors"
	"os"

	"golang.org/x/sys/execabs"
)

var askpassProgs = []string{
	"/usr/lib/ssh/ssh-askpass",
	"/usr/X11R6/bin/ssh-askpass",
	"/usr/libexec/openssh/ssh-askpass",
	"ssh-askpass",
}

func findAskPassProg() (string, error) {
	if p := os.Getenv("SSH_ASKPASS"); p != "" {
		return p, nil
	}

	for _, p := range askpassProgs {
		out, err := execabs.LookPath(p)
		if err == nil {
			return out, nil
		}
	}

	return "", errors.New("no ssh-askpass program found")
}
