package main

import (
	"encoding/base64"
	"encoding/json"
	"fmt"
	"os"

	"a.yandex-team.ru/security/skotty/libs/askpass/fakepass/fakepass"
)

func fatalf(msg string, a ...interface{}) {
	_, _ = fmt.Fprintf(os.Stderr, fmt.Sprintf("fakepass: %s \n", msg), a...)
	os.Exit(1)
}

func main() {
	var opts fakepass.Opts
	if len(os.Args) > 1 {
		rawOpts, err := base64.RawStdEncoding.DecodeString(os.Args[1])
		if err != nil {
			fatalf("unable to decode opts: %v", err)
		}

		if err := json.Unmarshal(rawOpts, &opts); err != nil {
			fatalf("unable to parse opts: %v", err)
		}
	}

	if opts.ExpectedPrompt != os.Getenv("SSH_ASKPASS_PROMPT") {
		fatalf(
			"unexpected SSH_ASKPASS_PROMPT: %q (expected) != %q (actual)",
			opts.ExpectedPrompt, os.Getenv("SSH_ASKPASS_PROMPT"),
		)
	}

	_, _ = os.Stdout.WriteString(opts.Output)
	os.Exit(opts.ExitCode)
}
