package certutil

import (
	"crypto/x509/pkix"
	"encoding/asn1"
	"fmt"
)

var (
	ExtNameTokenID  = asn1.ObjectIdentifier([]int{1, 3, 6, 1, 4, 1, 31337, 2, 1})
	ExtNameEnrollID = asn1.ObjectIdentifier([]int{1, 3, 6, 1, 4, 1, 31337, 2, 2})
	ExtNameUser     = asn1.ObjectIdentifier([]int{1, 3, 6, 1, 4, 1, 31337, 2, 3})
)

type ExtraName struct {
	TokenID  string
	EnrollID string
	User     string
}

func ParseExtraNames(names []pkix.AttributeTypeAndValue) (*ExtraName, error) {
	var out ExtraName
	for _, name := range names {
		switch {
		case name.Type.Equal(ExtNameTokenID):
			v, ok := name.Value.(string)
			if !ok {
				return nil, fmt.Errorf("unexpected token_id oid type: %T", name.Value)
			}
			out.TokenID = v
		case name.Type.Equal(ExtNameEnrollID):
			v, ok := name.Value.(string)
			if !ok {
				return nil, fmt.Errorf("unexpected enroll_id oid type: %T", name.Value)
			}
			out.EnrollID = v
		case name.Type.Equal(ExtNameUser):
			v, ok := name.Value.(string)
			if !ok {
				return nil, fmt.Errorf("unexpected user oid type: %T", name.Value)
			}
			out.User = v
		}
	}

	return &out, nil
}
