package isroot

import "golang.org/x/sys/windows"

func IsRoot() bool {
	if fakeRoot() {
		return true
	}

	var sid *windows.SID
	// https://docs.microsoft.com/en-us/windows/desktop/api/securitybaseapi/nf-securitybaseapi-checktokenmembership
	err := windows.AllocateAndInitializeSid(
		&windows.SECURITY_NT_AUTHORITY,
		2,
		windows.SECURITY_BUILTIN_DOMAIN_RID,
		windows.DOMAIN_ALIAS_RID_ADMINS,
		0, 0, 0, 0, 0, 0,
		&sid)
	if err != nil {
		return false
	}
	defer func() { _ = windows.FreeSid(sid) }()

	isMember, _ := windows.Token(0).IsMember(sid)
	return isMember
}
