package skotty

import "fmt"

type ServiceErrorCode int

const (
	ServiceErrorCodeNone ServiceErrorCode = iota
	ServiceErrorInvalidRequest
	ServiceErrorAttestationFailed
	ServiceErrorInternalError
	ServiceErrorUnauthorizedRequest
)

type ServiceError struct {
	Code ServiceErrorCode `json:"error_code"`
	Msg  string           `json:"message"`
}

func (e *ServiceError) Is(err error) bool {
	other, ok := err.(*ServiceError)
	if !ok {
		return false
	}

	if e == nil && other == nil {
		return true
	}
	if e == nil || other == nil {
		return false
	}
	return e.Code == other.Code
}

func (e *ServiceError) Error() string {
	if e.Msg != "" {
		return fmt.Sprintf("enroll (%d): %s", e.Code, e.Msg)
	}
	return fmt.Sprintf("enroll (%d)", e.Code)
}
