package skotty

import (
	"crypto/tls"
	"net/http"
	"time"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/certifi"
)

const (
	SnakeToken       = "8sH1QNN2QhVbIdrnFlmVpnTehotN0wbr"
	SnakeTokenHeader = "X-Host-Token"
	VersionHeader    = "X-Client-Version"
	DefaultUpstream  = "https://skotty.sec.yandex-team.ru"
)

type HTTPClient struct {
	*resty.Client
}

func NewHTTPClient(opts ...Option) *HTTPClient {
	httpc := resty.NewWithClient(&http.Client{Transport: newHTTPTransport()}).
		SetJSONEscapeHTML(false).
		SetHeader(SnakeTokenHeader, SnakeToken).
		SetHeader("Content-Type", "application/json").
		SetBaseURL(DefaultUpstream).
		SetRetryCount(3).
		SetRetryWaitTime(1 * time.Second).
		SetRetryMaxWaitTime(10 * time.Second).
		AddRetryCondition(func(rsp *resty.Response, err error) bool {
			return err != nil || rsp.StatusCode() == http.StatusInternalServerError
		})

	certPool, err := certifi.NewCertPool()
	if err == nil {
		httpc.SetTLSClientConfig(&tls.Config{RootCAs: certPool})
	}

	for _, o := range opts {
		switch v := o.(type) {
		case upstreamOption:
			httpc.SetBaseURL(v.baseURL)
		case clientVersionOption:
			httpc.SetHeader(VersionHeader, v.version)
		}
	}

	return &HTTPClient{
		Client: httpc,
	}
}
