package skotty

type Option interface {
	isOption()
}

type RoboOption interface {
	isRoboOption()
}

type EnrollOption interface {
	isEnrollOption()
}

type upstreamOption struct {
	Option
	RoboOption
	EnrollOption
	baseURL string
}

func WithUpstream(upstream string) upstreamOption {
	return upstreamOption{
		baseURL: upstream,
	}
}

type clientVersionOption struct {
	Option
	RoboOption
	EnrollOption
	version string
}

func WithClientVersion(version string) clientVersionOption {
	return clientVersionOption{
		version: version,
	}
}

type roboAuthTokenOption struct {
	RoboOption
	token string
}

func WithRoboAuthToken(token string) roboAuthTokenOption {
	return roboAuthTokenOption{
		token: token,
	}
}
