package skotty

import (
	"context"
	"fmt"
)

type RoboClient struct {
	httpc *HTTPClient
}

func NewRoboClient(opts ...RoboOption) *RoboClient {
	var httpOpts []Option
	var roboOpts []RoboOption
	for _, opt := range opts {
		if o, ok := opt.(Option); ok {
			httpOpts = append(httpOpts, o)
			continue
		}

		roboOpts = append(roboOpts, opt)
	}

	httpc := NewHTTPClient(httpOpts...)
	for _, opt := range roboOpts {
		switch v := opt.(type) {
		case roboAuthTokenOption:
			httpc.SetHeader("Authorization", "OAuth "+v.token)
		}
	}

	return &RoboClient{
		httpc: httpc,
	}
}

func (c *RoboClient) IssueCertificates(ctx context.Context, req *IssueRoboCertificatesReq) (*IssueRoboCertificatesRsp, error) {
	var out IssueRoboCertificatesRsp
	var serviceErr ServiceError
	rsp, err := c.httpc.R().
		SetContext(ctx).
		SetBody(req).
		SetError(&serviceErr).
		SetResult(&out).
		ForceContentType("application/json").
		Post("/api/v1/robots/issue")

	if err != nil {
		return nil, fmt.Errorf("request failed: %w", err)
	}

	if !rsp.IsSuccess() {
		if serviceErr.Code != ServiceErrorCodeNone {
			return nil, &serviceErr
		}

		return nil, fmt.Errorf("request failed: non-200 status code: %s", rsp.Status())
	}

	return &out, nil
}
