package skotty

type RequestRenewReq struct {
	Hostname     string    `json:"hostname"`
	TokenType    TokenType `json:"token_type"`
	TokenName    string    `json:"token_name"`
	TokenSerial  string    `json:"token_serial"`
	EnrollmentID string    `json:"enrollment_id"`
	User         string    `json:"user"`
	//deprecated
	RenewToken string `json:"renew_token"`
}

type RequestRenewRsp struct {
	EnrollmentID string `json:"enrollment_id"`
	AuthID       string `json:"auth_id"`
	AuthToken    string `json:"auth_token"`
	AuthURL      string `json:"auth_url"`
}

type RequestEnrollmentReq struct {
	Hostname    string    `json:"hostname"`
	TokenType   TokenType `json:"token_type"`
	TokenName   string    `json:"token_name"`
	TokenSerial string    `json:"token_serial"`
}

type RequestEnrollmentRsp struct {
	EnrollmentID string `json:"enrollment_id"`
	AuthID       string `json:"auth_id"`
	AuthToken    string `json:"auth_token"`
	AuthURL      string `json:"auth_url"`
}

type ApproveRenewReq struct {
	AuthToken string `json:"auth_token"`
	Sign      []byte `json:"sign"`
	SignKey   []byte `json:"sign_key"`
}

type IssueRenewReq struct {
	AuthToken       string                 `json:"auth_token"`
	TokenType       TokenType              `json:"token_type"`
	AttestationCert []byte                 `json:"attestation_crt"`
	Certificates    []RequestedCertificate `json:"certificates"`
}

type IssueRenewRsp struct {
	ExpiresAt    int64               `json:"expires_at"`
	Certificates []IssuedCertificate `json:"certificates"`
	EnrollInfo   EnrollmentInfo      `json:"enroll_info"`
	//deprecated
	RenewToken string `json:"renew_token"`
}

type IssueEnrollmentReq struct {
	AuthToken       string                 `json:"auth_token"`
	TokenType       TokenType              `json:"token_type"`
	AttestationCert []byte                 `json:"attestation_crt"`
	Certificates    []RequestedCertificate `json:"certificates"`
}

type IssueEnrollmentRsp struct {
	ExpiresAt     int64               `json:"expires_at"`
	Certificates  []IssuedCertificate `json:"certificates"`
	EnrollInfo    EnrollmentInfo      `json:"enroll_info"`
	KeysUpdated   bool                `json:"keys_updated"`
	KeysUpdateErr string              `json:"keys_update_err"`
	//deprecated
	RenewToken string `json:"renew_token"`
}

type HostCa struct {
	Type  CertType `json:"type"`
	SSHCa []byte   `json:"ssh_ca"`
}

type GetPubsRsp struct {
	Keys []HostCa `json:"keys"`
}

type RequestedCertificate struct {
	HostID          int      `json:"host_id"`
	Type            CertType `json:"cert_type"`
	AttestationCert []byte   `json:"attestation_crt"`
	Cert            []byte   `json:"cert"`
}

type IssuedCertificate struct {
	Serial        string        `json:"-"`
	AuthorizedKey AuthorizedKey `json:"-"`
	HostID        int           `json:"host_id"`
	Type          CertType      `json:"cert_type"`
	Cert          []byte        `json:"cert"`
	SSHCert       []byte        `json:"ssh_pub"`
}

type EnrollmentInfo struct {
	EnrollID    string `json:"enrollment_id"`
	TokenSerial string `json:"token_serial"`
	User        string `json:"user"`
}

type IssueRoboCertificatesReq struct {
	Hostname     string                 `json:"hostname"`
	TokenName    string                 `json:"token_name"`
	TokenSerial  string                 `json:"token_serial"`
	Certificates []RequestedCertificate `json:"certificates"`
}

type IssueRoboCertificatesRsp struct {
	ExpiresAt    int64               `json:"expires_at"`
	Certificates []IssuedCertificate `json:"certificates"`
}

type AuthorizedKey struct {
	Key         string `json:"key"`
	Fingerprint string `json:"fingerprint"`
	Description string `json:"description"`
}
